#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>

// To compile: cl.exe /W3 /O2 skype_debuglog.c
// Hint: The closest Skype launch is from system boot, the fastest the key will be recovered
// Tested on a 2.0.0.79 & a 2.0.0.81

/*
To activate (encrypted) debug logs, import the following to Windows registry
Logging.reg:
----------
Windows Registry Editor Version 5.00

[HKEY_CURRENT_USER\Software\Skype\Phone\UI\General]
"Logging"="SkypeDebug2003"
----------
*/

#define SIZE 1024

static unsigned char buffer[SIZE];
static unsigned char base_state[256];
static char filename[260];
static unsigned char key_16[256];

#define swap_byte(x,y) t = *(x); *(x) = *(y); *(y) = t

typedef struct rc4_key
{      
   unsigned char state[256];       
   unsigned char x;        
   unsigned char y;
} rc4_key;

void prepare_key(unsigned char *key_data_ptr, int key_data_len, rc4_key *key)
{
  unsigned char t;
  unsigned char index1;
  unsigned char index2;
  unsigned char* state;
  short counter;

  state = &key->state[0];
  for(counter = 0; counter < 256; counter++)
    state[counter] = (unsigned char)counter;
  key->x = 0;
  key->y = 0;
  index1 = 0;
  index2 = 0;
  for(counter = 0; counter < 256; counter++)
  {
    index2 = (key_data_ptr[index1] + state[counter] + index2) % 256;
    swap_byte(&state[counter], &state[index2]);
    index1 = (index1 + 1) % key_data_len;
  }
}

void rc4(unsigned char *buffer_ptr, int buffer_len, rc4_key *key)
{
  unsigned char t;
  unsigned char x;
  unsigned char y;
  unsigned char* state;
  unsigned char xorIndex;
  short counter;

  x = key->x;
  y = key->y;
  state = &key->state[0];
  for(counter = 0; counter < buffer_len; counter++)
  {
    x = (x + 1) % 256;
    y = (state[x] + y) % 256;
    swap_byte(&state[x], &state[y]);
    xorIndex = (state[x] + state[y]) % 256;
    buffer_ptr[counter] ^= state[xorIndex];
  }
  key->x = x;
  key->y = y;
}

__forceinline void prepare_key_16(unsigned char *key_data_ptr)
{
  unsigned char t;
  unsigned char index;

  memcpy(key_16, base_state, sizeof(base_state));
  index = key_data_ptr[0] + key_16[0];
  swap_byte(&key_16[0], &key_16[index]);
  index += key_data_ptr[1] + key_16[1];
  swap_byte(&key_16[1], &key_16[index]);
  index += key_data_ptr[2] + key_16[2];
  swap_byte(&key_16[2], &key_16[index]);
  index += key_data_ptr[3] + key_16[3];
  swap_byte(&key_16[3], &key_16[index]);
  index += key_data_ptr[4] + key_16[4];
  swap_byte(&key_16[4], &key_16[index]);
  index += key_data_ptr[5] + key_16[5];
  swap_byte(&key_16[5], &key_16[index]);
  index += key_data_ptr[6] + key_16[6];
  swap_byte(&key_16[6], &key_16[index]);
  index += key_data_ptr[7] + key_16[7];
  swap_byte(&key_16[7], &key_16[index]);
  index += key_data_ptr[8] + key_16[8];
  swap_byte(&key_16[8], &key_16[index]);
  index += key_data_ptr[9] + key_16[9];
  swap_byte(&key_16[9], &key_16[index]);
  index += key_data_ptr[10] + key_16[10];
  swap_byte(&key_16[10], &key_16[index]);
  index += key_data_ptr[11] + key_16[11];
  swap_byte(&key_16[11], &key_16[index]);
  index += key_data_ptr[12] + key_16[12];
  swap_byte(&key_16[12], &key_16[index]);
  index += key_data_ptr[13] + key_16[13];
  swap_byte(&key_16[13], &key_16[index]);
  index += key_data_ptr[14] + key_16[14];
  swap_byte(&key_16[14], &key_16[index]);
  index += key_data_ptr[15] + key_16[15];
  swap_byte(&key_16[15], &key_16[index]);
  index += key_data_ptr[0] + key_16[16];
  swap_byte(&key_16[16], &key_16[index]);
  index += key_data_ptr[1] + key_16[17];
  swap_byte(&key_16[17], &key_16[index]);
  index += key_data_ptr[2] + key_16[18];
  swap_byte(&key_16[18], &key_16[index]);
  index += key_data_ptr[3] + key_16[19];
  swap_byte(&key_16[19], &key_16[index]);
  index += key_data_ptr[4] + key_16[20];
  swap_byte(&key_16[20], &key_16[index]);
  index += key_data_ptr[5] + key_16[21];
  swap_byte(&key_16[21], &key_16[index]);
  index += key_data_ptr[6] + key_16[22];
  swap_byte(&key_16[22], &key_16[index]);
  index += key_data_ptr[7] + key_16[23];
  swap_byte(&key_16[23], &key_16[index]);
  index += key_data_ptr[8] + key_16[24];
  swap_byte(&key_16[24], &key_16[index]);
  index += key_data_ptr[9] + key_16[25];
  swap_byte(&key_16[25], &key_16[index]);
  index += key_data_ptr[10] + key_16[26];
  swap_byte(&key_16[26], &key_16[index]);
  index += key_data_ptr[11] + key_16[27];
  swap_byte(&key_16[27], &key_16[index]);
  index += key_data_ptr[12] + key_16[28];
  swap_byte(&key_16[28], &key_16[index]);
  index += key_data_ptr[13] + key_16[29];
  swap_byte(&key_16[29], &key_16[index]);
  index += key_data_ptr[14] + key_16[30];
  swap_byte(&key_16[30], &key_16[index]);
  index += key_data_ptr[15] + key_16[31];
  swap_byte(&key_16[31], &key_16[index]);
  index += key_data_ptr[0] + key_16[32];
  swap_byte(&key_16[32], &key_16[index]);
  index += key_data_ptr[1] + key_16[33];
  swap_byte(&key_16[33], &key_16[index]);
  index += key_data_ptr[2] + key_16[34];
  swap_byte(&key_16[34], &key_16[index]);
  index += key_data_ptr[3] + key_16[35];
  swap_byte(&key_16[35], &key_16[index]);
  index += key_data_ptr[4] + key_16[36];
  swap_byte(&key_16[36], &key_16[index]);
  index += key_data_ptr[5] + key_16[37];
  swap_byte(&key_16[37], &key_16[index]);
  index += key_data_ptr[6] + key_16[38];
  swap_byte(&key_16[38], &key_16[index]);
  index += key_data_ptr[7] + key_16[39];
  swap_byte(&key_16[39], &key_16[index]);
  index += key_data_ptr[8] + key_16[40];
  swap_byte(&key_16[40], &key_16[index]);
  index += key_data_ptr[9] + key_16[41];
  swap_byte(&key_16[41], &key_16[index]);
  index += key_data_ptr[10] + key_16[42];
  swap_byte(&key_16[42], &key_16[index]);
  index += key_data_ptr[11] + key_16[43];
  swap_byte(&key_16[43], &key_16[index]);
  index += key_data_ptr[12] + key_16[44];
  swap_byte(&key_16[44], &key_16[index]);
  index += key_data_ptr[13] + key_16[45];
  swap_byte(&key_16[45], &key_16[index]);
  index += key_data_ptr[14] + key_16[46];
  swap_byte(&key_16[46], &key_16[index]);
  index += key_data_ptr[15] + key_16[47];
  swap_byte(&key_16[47], &key_16[index]);
  index += key_data_ptr[0] + key_16[48];
  swap_byte(&key_16[48], &key_16[index]);
  index += key_data_ptr[1] + key_16[49];
  swap_byte(&key_16[49], &key_16[index]);
  index += key_data_ptr[2] + key_16[50];
  swap_byte(&key_16[50], &key_16[index]);
  index += key_data_ptr[3] + key_16[51];
  swap_byte(&key_16[51], &key_16[index]);
  index += key_data_ptr[4] + key_16[52];
  swap_byte(&key_16[52], &key_16[index]);
  index += key_data_ptr[5] + key_16[53];
  swap_byte(&key_16[53], &key_16[index]);
  index += key_data_ptr[6] + key_16[54];
  swap_byte(&key_16[54], &key_16[index]);
  index += key_data_ptr[7] + key_16[55];
  swap_byte(&key_16[55], &key_16[index]);
  index += key_data_ptr[8] + key_16[56];
  swap_byte(&key_16[56], &key_16[index]);
  index += key_data_ptr[9] + key_16[57];
  swap_byte(&key_16[57], &key_16[index]);
  index += key_data_ptr[10] + key_16[58];
  swap_byte(&key_16[58], &key_16[index]);
  index += key_data_ptr[11] + key_16[59];
  swap_byte(&key_16[59], &key_16[index]);
  index += key_data_ptr[12] + key_16[60];
  swap_byte(&key_16[60], &key_16[index]);
  index += key_data_ptr[13] + key_16[61];
  swap_byte(&key_16[61], &key_16[index]);
  index += key_data_ptr[14] + key_16[62];
  swap_byte(&key_16[62], &key_16[index]);
  index += key_data_ptr[15] + key_16[63];
  swap_byte(&key_16[63], &key_16[index]);
  index += key_data_ptr[0] + key_16[64];
  swap_byte(&key_16[64], &key_16[index]);
  index += key_data_ptr[1] + key_16[65];
  swap_byte(&key_16[65], &key_16[index]);
  index += key_data_ptr[2] + key_16[66];
  swap_byte(&key_16[66], &key_16[index]);
  index += key_data_ptr[3] + key_16[67];
  swap_byte(&key_16[67], &key_16[index]);
  index += key_data_ptr[4] + key_16[68];
  swap_byte(&key_16[68], &key_16[index]);
  index += key_data_ptr[5] + key_16[69];
  swap_byte(&key_16[69], &key_16[index]);
  index += key_data_ptr[6] + key_16[70];
  swap_byte(&key_16[70], &key_16[index]);
  index += key_data_ptr[7] + key_16[71];
  swap_byte(&key_16[71], &key_16[index]);
  index += key_data_ptr[8] + key_16[72];
  swap_byte(&key_16[72], &key_16[index]);
  index += key_data_ptr[9] + key_16[73];
  swap_byte(&key_16[73], &key_16[index]);
  index += key_data_ptr[10] + key_16[74];
  swap_byte(&key_16[74], &key_16[index]);
  index += key_data_ptr[11] + key_16[75];
  swap_byte(&key_16[75], &key_16[index]);
  index += key_data_ptr[12] + key_16[76];
  swap_byte(&key_16[76], &key_16[index]);
  index += key_data_ptr[13] + key_16[77];
  swap_byte(&key_16[77], &key_16[index]);
  index += key_data_ptr[14] + key_16[78];
  swap_byte(&key_16[78], &key_16[index]);
  index += key_data_ptr[15] + key_16[79];
  swap_byte(&key_16[79], &key_16[index]);
  index += key_data_ptr[0] + key_16[80];
  swap_byte(&key_16[80], &key_16[index]);
  index += key_data_ptr[1] + key_16[81];
  swap_byte(&key_16[81], &key_16[index]);
  index += key_data_ptr[2] + key_16[82];
  swap_byte(&key_16[82], &key_16[index]);
  index += key_data_ptr[3] + key_16[83];
  swap_byte(&key_16[83], &key_16[index]);
  index += key_data_ptr[4] + key_16[84];
  swap_byte(&key_16[84], &key_16[index]);
  index += key_data_ptr[5] + key_16[85];
  swap_byte(&key_16[85], &key_16[index]);
  index += key_data_ptr[6] + key_16[86];
  swap_byte(&key_16[86], &key_16[index]);
  index += key_data_ptr[7] + key_16[87];
  swap_byte(&key_16[87], &key_16[index]);
  index += key_data_ptr[8] + key_16[88];
  swap_byte(&key_16[88], &key_16[index]);
  index += key_data_ptr[9] + key_16[89];
  swap_byte(&key_16[89], &key_16[index]);
  index += key_data_ptr[10] + key_16[90];
  swap_byte(&key_16[90], &key_16[index]);
  index += key_data_ptr[11] + key_16[91];
  swap_byte(&key_16[91], &key_16[index]);
  index += key_data_ptr[12] + key_16[92];
  swap_byte(&key_16[92], &key_16[index]);
  index += key_data_ptr[13] + key_16[93];
  swap_byte(&key_16[93], &key_16[index]);
  index += key_data_ptr[14] + key_16[94];
  swap_byte(&key_16[94], &key_16[index]);
  index += key_data_ptr[15] + key_16[95];
  swap_byte(&key_16[95], &key_16[index]);
  index += key_data_ptr[0] + key_16[96];
  swap_byte(&key_16[96], &key_16[index]);
  index += key_data_ptr[1] + key_16[97];
  swap_byte(&key_16[97], &key_16[index]);
  index += key_data_ptr[2] + key_16[98];
  swap_byte(&key_16[98], &key_16[index]);
  index += key_data_ptr[3] + key_16[99];
  swap_byte(&key_16[99], &key_16[index]);
  index += key_data_ptr[4] + key_16[100];
  swap_byte(&key_16[100], &key_16[index]);
  index += key_data_ptr[5] + key_16[101];
  swap_byte(&key_16[101], &key_16[index]);
  index += key_data_ptr[6] + key_16[102];
  swap_byte(&key_16[102], &key_16[index]);
  index += key_data_ptr[7] + key_16[103];
  swap_byte(&key_16[103], &key_16[index]);
  index += key_data_ptr[8] + key_16[104];
  swap_byte(&key_16[104], &key_16[index]);
  index += key_data_ptr[9] + key_16[105];
  swap_byte(&key_16[105], &key_16[index]);
  index += key_data_ptr[10] + key_16[106];
  swap_byte(&key_16[106], &key_16[index]);
  index += key_data_ptr[11] + key_16[107];
  swap_byte(&key_16[107], &key_16[index]);
  index += key_data_ptr[12] + key_16[108];
  swap_byte(&key_16[108], &key_16[index]);
  index += key_data_ptr[13] + key_16[109];
  swap_byte(&key_16[109], &key_16[index]);
  index += key_data_ptr[14] + key_16[110];
  swap_byte(&key_16[110], &key_16[index]);
  index += key_data_ptr[15] + key_16[111];
  swap_byte(&key_16[111], &key_16[index]);
  index += key_data_ptr[0] + key_16[112];
  swap_byte(&key_16[112], &key_16[index]);
  index += key_data_ptr[1] + key_16[113];
  swap_byte(&key_16[113], &key_16[index]);
  index += key_data_ptr[2] + key_16[114];
  swap_byte(&key_16[114], &key_16[index]);
  index += key_data_ptr[3] + key_16[115];
  swap_byte(&key_16[115], &key_16[index]);
  index += key_data_ptr[4] + key_16[116];
  swap_byte(&key_16[116], &key_16[index]);
  index += key_data_ptr[5] + key_16[117];
  swap_byte(&key_16[117], &key_16[index]);
  index += key_data_ptr[6] + key_16[118];
  swap_byte(&key_16[118], &key_16[index]);
  index += key_data_ptr[7] + key_16[119];
  swap_byte(&key_16[119], &key_16[index]);
  index += key_data_ptr[8] + key_16[120];
  swap_byte(&key_16[120], &key_16[index]);
  index += key_data_ptr[9] + key_16[121];
  swap_byte(&key_16[121], &key_16[index]);
  index += key_data_ptr[10] + key_16[122];
  swap_byte(&key_16[122], &key_16[index]);
  index += key_data_ptr[11] + key_16[123];
  swap_byte(&key_16[123], &key_16[index]);
  index += key_data_ptr[12] + key_16[124];
  swap_byte(&key_16[124], &key_16[index]);
  index += key_data_ptr[13] + key_16[125];
  swap_byte(&key_16[125], &key_16[index]);
  index += key_data_ptr[14] + key_16[126];
  swap_byte(&key_16[126], &key_16[index]);
  index += key_data_ptr[15] + key_16[127];
  swap_byte(&key_16[127], &key_16[index]);
  index += key_data_ptr[0] + key_16[128];
  swap_byte(&key_16[128], &key_16[index]);
  index += key_data_ptr[1] + key_16[129];
  swap_byte(&key_16[129], &key_16[index]);
  index += key_data_ptr[2] + key_16[130];
  swap_byte(&key_16[130], &key_16[index]);
  index += key_data_ptr[3] + key_16[131];
  swap_byte(&key_16[131], &key_16[index]);
  index += key_data_ptr[4] + key_16[132];
  swap_byte(&key_16[132], &key_16[index]);
  index += key_data_ptr[5] + key_16[133];
  swap_byte(&key_16[133], &key_16[index]);
  index += key_data_ptr[6] + key_16[134];
  swap_byte(&key_16[134], &key_16[index]);
  index += key_data_ptr[7] + key_16[135];
  swap_byte(&key_16[135], &key_16[index]);
  index += key_data_ptr[8] + key_16[136];
  swap_byte(&key_16[136], &key_16[index]);
  index += key_data_ptr[9] + key_16[137];
  swap_byte(&key_16[137], &key_16[index]);
  index += key_data_ptr[10] + key_16[138];
  swap_byte(&key_16[138], &key_16[index]);
  index += key_data_ptr[11] + key_16[139];
  swap_byte(&key_16[139], &key_16[index]);
  index += key_data_ptr[12] + key_16[140];
  swap_byte(&key_16[140], &key_16[index]);
  index += key_data_ptr[13] + key_16[141];
  swap_byte(&key_16[141], &key_16[index]);
  index += key_data_ptr[14] + key_16[142];
  swap_byte(&key_16[142], &key_16[index]);
  index += key_data_ptr[15] + key_16[143];
  swap_byte(&key_16[143], &key_16[index]);
  index += key_data_ptr[0] + key_16[144];
  swap_byte(&key_16[144], &key_16[index]);
  index += key_data_ptr[1] + key_16[145];
  swap_byte(&key_16[145], &key_16[index]);
  index += key_data_ptr[2] + key_16[146];
  swap_byte(&key_16[146], &key_16[index]);
  index += key_data_ptr[3] + key_16[147];
  swap_byte(&key_16[147], &key_16[index]);
  index += key_data_ptr[4] + key_16[148];
  swap_byte(&key_16[148], &key_16[index]);
  index += key_data_ptr[5] + key_16[149];
  swap_byte(&key_16[149], &key_16[index]);
  index += key_data_ptr[6] + key_16[150];
  swap_byte(&key_16[150], &key_16[index]);
  index += key_data_ptr[7] + key_16[151];
  swap_byte(&key_16[151], &key_16[index]);
  index += key_data_ptr[8] + key_16[152];
  swap_byte(&key_16[152], &key_16[index]);
  index += key_data_ptr[9] + key_16[153];
  swap_byte(&key_16[153], &key_16[index]);
  index += key_data_ptr[10] + key_16[154];
  swap_byte(&key_16[154], &key_16[index]);
  index += key_data_ptr[11] + key_16[155];
  swap_byte(&key_16[155], &key_16[index]);
  index += key_data_ptr[12] + key_16[156];
  swap_byte(&key_16[156], &key_16[index]);
  index += key_data_ptr[13] + key_16[157];
  swap_byte(&key_16[157], &key_16[index]);
  index += key_data_ptr[14] + key_16[158];
  swap_byte(&key_16[158], &key_16[index]);
  index += key_data_ptr[15] + key_16[159];
  swap_byte(&key_16[159], &key_16[index]);
  index += key_data_ptr[0] + key_16[160];
  swap_byte(&key_16[160], &key_16[index]);
  index += key_data_ptr[1] + key_16[161];
  swap_byte(&key_16[161], &key_16[index]);
  index += key_data_ptr[2] + key_16[162];
  swap_byte(&key_16[162], &key_16[index]);
  index += key_data_ptr[3] + key_16[163];
  swap_byte(&key_16[163], &key_16[index]);
  index += key_data_ptr[4] + key_16[164];
  swap_byte(&key_16[164], &key_16[index]);
  index += key_data_ptr[5] + key_16[165];
  swap_byte(&key_16[165], &key_16[index]);
  index += key_data_ptr[6] + key_16[166];
  swap_byte(&key_16[166], &key_16[index]);
  index += key_data_ptr[7] + key_16[167];
  swap_byte(&key_16[167], &key_16[index]);
  index += key_data_ptr[8] + key_16[168];
  swap_byte(&key_16[168], &key_16[index]);
  index += key_data_ptr[9] + key_16[169];
  swap_byte(&key_16[169], &key_16[index]);
  index += key_data_ptr[10] + key_16[170];
  swap_byte(&key_16[170], &key_16[index]);
  index += key_data_ptr[11] + key_16[171];
  swap_byte(&key_16[171], &key_16[index]);
  index += key_data_ptr[12] + key_16[172];
  swap_byte(&key_16[172], &key_16[index]);
  index += key_data_ptr[13] + key_16[173];
  swap_byte(&key_16[173], &key_16[index]);
  index += key_data_ptr[14] + key_16[174];
  swap_byte(&key_16[174], &key_16[index]);
  index += key_data_ptr[15] + key_16[175];
  swap_byte(&key_16[175], &key_16[index]);
  index += key_data_ptr[0] + key_16[176];
  swap_byte(&key_16[176], &key_16[index]);
  index += key_data_ptr[1] + key_16[177];
  swap_byte(&key_16[177], &key_16[index]);
  index += key_data_ptr[2] + key_16[178];
  swap_byte(&key_16[178], &key_16[index]);
  index += key_data_ptr[3] + key_16[179];
  swap_byte(&key_16[179], &key_16[index]);
  index += key_data_ptr[4] + key_16[180];
  swap_byte(&key_16[180], &key_16[index]);
  index += key_data_ptr[5] + key_16[181];
  swap_byte(&key_16[181], &key_16[index]);
  index += key_data_ptr[6] + key_16[182];
  swap_byte(&key_16[182], &key_16[index]);
  index += key_data_ptr[7] + key_16[183];
  swap_byte(&key_16[183], &key_16[index]);
  index += key_data_ptr[8] + key_16[184];
  swap_byte(&key_16[184], &key_16[index]);
  index += key_data_ptr[9] + key_16[185];
  swap_byte(&key_16[185], &key_16[index]);
  index += key_data_ptr[10] + key_16[186];
  swap_byte(&key_16[186], &key_16[index]);
  index += key_data_ptr[11] + key_16[187];
  swap_byte(&key_16[187], &key_16[index]);
  index += key_data_ptr[12] + key_16[188];
  swap_byte(&key_16[188], &key_16[index]);
  index += key_data_ptr[13] + key_16[189];
  swap_byte(&key_16[189], &key_16[index]);
  index += key_data_ptr[14] + key_16[190];
  swap_byte(&key_16[190], &key_16[index]);
  index += key_data_ptr[15] + key_16[191];
  swap_byte(&key_16[191], &key_16[index]);
  index += key_data_ptr[0] + key_16[192];
  swap_byte(&key_16[192], &key_16[index]);
  index += key_data_ptr[1] + key_16[193];
  swap_byte(&key_16[193], &key_16[index]);
  index += key_data_ptr[2] + key_16[194];
  swap_byte(&key_16[194], &key_16[index]);
  index += key_data_ptr[3] + key_16[195];
  swap_byte(&key_16[195], &key_16[index]);
  index += key_data_ptr[4] + key_16[196];
  swap_byte(&key_16[196], &key_16[index]);
  index += key_data_ptr[5] + key_16[197];
  swap_byte(&key_16[197], &key_16[index]);
  index += key_data_ptr[6] + key_16[198];
  swap_byte(&key_16[198], &key_16[index]);
  index += key_data_ptr[7] + key_16[199];
  swap_byte(&key_16[199], &key_16[index]);
  index += key_data_ptr[8] + key_16[200];
  swap_byte(&key_16[200], &key_16[index]);
  index += key_data_ptr[9] + key_16[201];
  swap_byte(&key_16[201], &key_16[index]);
  index += key_data_ptr[10] + key_16[202];
  swap_byte(&key_16[202], &key_16[index]);
  index += key_data_ptr[11] + key_16[203];
  swap_byte(&key_16[203], &key_16[index]);
  index += key_data_ptr[12] + key_16[204];
  swap_byte(&key_16[204], &key_16[index]);
  index += key_data_ptr[13] + key_16[205];
  swap_byte(&key_16[205], &key_16[index]);
  index += key_data_ptr[14] + key_16[206];
  swap_byte(&key_16[206], &key_16[index]);
  index += key_data_ptr[15] + key_16[207];
  swap_byte(&key_16[207], &key_16[index]);
  index += key_data_ptr[0] + key_16[208];
  swap_byte(&key_16[208], &key_16[index]);
  index += key_data_ptr[1] + key_16[209];
  swap_byte(&key_16[209], &key_16[index]);
  index += key_data_ptr[2] + key_16[210];
  swap_byte(&key_16[210], &key_16[index]);
  index += key_data_ptr[3] + key_16[211];
  swap_byte(&key_16[211], &key_16[index]);
  index += key_data_ptr[4] + key_16[212];
  swap_byte(&key_16[212], &key_16[index]);
  index += key_data_ptr[5] + key_16[213];
  swap_byte(&key_16[213], &key_16[index]);
  index += key_data_ptr[6] + key_16[214];
  swap_byte(&key_16[214], &key_16[index]);
  index += key_data_ptr[7] + key_16[215];
  swap_byte(&key_16[215], &key_16[index]);
  index += key_data_ptr[8] + key_16[216];
  swap_byte(&key_16[216], &key_16[index]);
  index += key_data_ptr[9] + key_16[217];
  swap_byte(&key_16[217], &key_16[index]);
  index += key_data_ptr[10] + key_16[218];
  swap_byte(&key_16[218], &key_16[index]);
  index += key_data_ptr[11] + key_16[219];
  swap_byte(&key_16[219], &key_16[index]);
  index += key_data_ptr[12] + key_16[220];
  swap_byte(&key_16[220], &key_16[index]);
  index += key_data_ptr[13] + key_16[221];
  swap_byte(&key_16[221], &key_16[index]);
  index += key_data_ptr[14] + key_16[222];
  swap_byte(&key_16[222], &key_16[index]);
  index += key_data_ptr[15] + key_16[223];
  swap_byte(&key_16[223], &key_16[index]);
  index += key_data_ptr[0] + key_16[224];
  swap_byte(&key_16[224], &key_16[index]);
  index += key_data_ptr[1] + key_16[225];
  swap_byte(&key_16[225], &key_16[index]);
  index += key_data_ptr[2] + key_16[226];
  swap_byte(&key_16[226], &key_16[index]);
  index += key_data_ptr[3] + key_16[227];
  swap_byte(&key_16[227], &key_16[index]);
  index += key_data_ptr[4] + key_16[228];
  swap_byte(&key_16[228], &key_16[index]);
  index += key_data_ptr[5] + key_16[229];
  swap_byte(&key_16[229], &key_16[index]);
  index += key_data_ptr[6] + key_16[230];
  swap_byte(&key_16[230], &key_16[index]);
  index += key_data_ptr[7] + key_16[231];
  swap_byte(&key_16[231], &key_16[index]);
  index += key_data_ptr[8] + key_16[232];
  swap_byte(&key_16[232], &key_16[index]);
  index += key_data_ptr[9] + key_16[233];
  swap_byte(&key_16[233], &key_16[index]);
  index += key_data_ptr[10] + key_16[234];
  swap_byte(&key_16[234], &key_16[index]);
  index += key_data_ptr[11] + key_16[235];
  swap_byte(&key_16[235], &key_16[index]);
  index += key_data_ptr[12] + key_16[236];
  swap_byte(&key_16[236], &key_16[index]);
  index += key_data_ptr[13] + key_16[237];
  swap_byte(&key_16[237], &key_16[index]);
  index += key_data_ptr[14] + key_16[238];
  swap_byte(&key_16[238], &key_16[index]);
  index += key_data_ptr[15] + key_16[239];
  swap_byte(&key_16[239], &key_16[index]);
  index += key_data_ptr[0] + key_16[240];
  swap_byte(&key_16[240], &key_16[index]);
  index += key_data_ptr[1] + key_16[241];
  swap_byte(&key_16[241], &key_16[index]);
  index += key_data_ptr[2] + key_16[242];
  swap_byte(&key_16[242], &key_16[index]);
  index += key_data_ptr[3] + key_16[243];
  swap_byte(&key_16[243], &key_16[index]);
  index += key_data_ptr[4] + key_16[244];
  swap_byte(&key_16[244], &key_16[index]);
  index += key_data_ptr[5] + key_16[245];
  swap_byte(&key_16[245], &key_16[index]);
  index += key_data_ptr[6] + key_16[246];
  swap_byte(&key_16[246], &key_16[index]);
  index += key_data_ptr[7] + key_16[247];
  swap_byte(&key_16[247], &key_16[index]);
  index += key_data_ptr[8] + key_16[248];
  swap_byte(&key_16[248], &key_16[index]);
  index += key_data_ptr[9] + key_16[249];
  swap_byte(&key_16[249], &key_16[index]);
  index += key_data_ptr[10] + key_16[250];
  swap_byte(&key_16[250], &key_16[index]);
  index += key_data_ptr[11] + key_16[251];
  swap_byte(&key_16[251], &key_16[index]);
  index += key_data_ptr[12] + key_16[252];
  swap_byte(&key_16[252], &key_16[index]);
  index += key_data_ptr[13] + key_16[253];
  swap_byte(&key_16[253], &key_16[index]);
  index += key_data_ptr[14] + key_16[254];
  swap_byte(&key_16[254], &key_16[index]);
  index += key_data_ptr[15] + key_16[255];
  swap_byte(&key_16[255], &key_16[index]);
}

__forceinline void rc4_16(unsigned char *buffer_ptr)
{
  unsigned char t;
  unsigned char x;
  unsigned char xorIndex;

  // 16 first rounds of RC4 unrolled
  x = key_16[1];
  swap_byte(&key_16[1], &key_16[x]);
  xorIndex = key_16[1] + key_16[x];
  buffer_ptr[0] ^= key_16[xorIndex];
  x += key_16[2];
  swap_byte(&key_16[2], &key_16[x]);
  xorIndex = key_16[2] + key_16[x];
  buffer_ptr[1] ^= key_16[xorIndex];
  x += key_16[3];
  swap_byte(&key_16[3], &key_16[x]);
  xorIndex = key_16[3] + key_16[x];
  buffer_ptr[2] ^= key_16[xorIndex];
  x += key_16[4];
  swap_byte(&key_16[4], &key_16[x]);
  xorIndex = key_16[4] + key_16[x];
  buffer_ptr[3] ^= key_16[xorIndex];
  x += key_16[5];
  swap_byte(&key_16[5], &key_16[x]);
  xorIndex = key_16[5] + key_16[x];
  buffer_ptr[4] ^= key_16[xorIndex];
  x += key_16[6];
  swap_byte(&key_16[6], &key_16[x]);
  xorIndex = key_16[6] + key_16[x];
  buffer_ptr[5] ^= key_16[xorIndex];
  x += key_16[7];
  swap_byte(&key_16[7], &key_16[x]);
  xorIndex = key_16[7] + key_16[x];
  buffer_ptr[6] ^= key_16[xorIndex];
  x += key_16[8];
  swap_byte(&key_16[8], &key_16[x]);
  xorIndex = key_16[8] + key_16[x];
  buffer_ptr[7] ^= key_16[xorIndex];
  x += key_16[9];
  swap_byte(&key_16[9], &key_16[x]);
  xorIndex = key_16[9] + key_16[x];
  buffer_ptr[8] ^= key_16[xorIndex];
  x += key_16[10];
  swap_byte(&key_16[10], &key_16[x]);
  xorIndex = key_16[10] + key_16[x];
  buffer_ptr[9] ^= key_16[xorIndex];
  x += key_16[11];
  swap_byte(&key_16[11], &key_16[x]);
  xorIndex = key_16[11] + key_16[x];
  buffer_ptr[10] ^= key_16[xorIndex];
  x += key_16[12];
  swap_byte(&key_16[12], &key_16[x]);
  xorIndex = key_16[12] + key_16[x];
  buffer_ptr[11] ^= key_16[xorIndex];
  x += key_16[13];
  swap_byte(&key_16[13], &key_16[x]);
  xorIndex = key_16[13] + key_16[x];
  buffer_ptr[12] ^= key_16[xorIndex];
  x += key_16[14];
  swap_byte(&key_16[14], &key_16[x]);
  xorIndex = key_16[14] + key_16[x];
  buffer_ptr[13] ^= key_16[xorIndex];
  x += key_16[15];
  swap_byte(&key_16[15], &key_16[x]);
  xorIndex = key_16[15] + key_16[x];
  buffer_ptr[14] ^= key_16[xorIndex];
  x += key_16[16];
  swap_byte(&key_16[16], &key_16[x]);
  xorIndex = key_16[16] + key_16[x];
  buffer_ptr[15] ^= key_16[xorIndex];
}

void usage(char *program)
{
  printf("Usage: %s [-b | -k hexadecimal_key] debuglog_file\n", program);
  exit(-1);
}

int main(int argc, char* argv[])
{
  unsigned long i, j, k, l, time_base, backup_time_base;
  FILE *encrypted_file, *decrypted_file;
  struct tm when;
  unsigned char daylight_saving, encrypted_buffer[16], decrypted_buffer[16];
  unsigned long key_data[4];
  unsigned char *p, do_decrypt;
  rc4_key key;

  if (argc != 3 && argc != 4)
    usage(argv[0]);
  do_decrypt = 0;
  if (argc == 4)
  {
    if (strcmp(argv[1], "-k") != 0)
      usage(argv[0]);
    strncpy(filename, argv[3], sizeof(filename) - 1);
    filename[sizeof(filename) - 1] = '\0';
    do_decrypt = 1;
    p = argv[2];
    if (strlen(p) != 32)
    {
      printf("Invalid key length\n");
      return -1;
    }
    for (i = 0, j = 0; i < 32; i += 2)
    {
      memcpy(encrypted_buffer, &p[i], 2);
      encrypted_buffer[2] = '\0';
      sscanf(encrypted_buffer, "%02x", &k);
      ((unsigned char *)key_data)[j++] = (unsigned char)k;
    }
    goto Decrypt;
  }
  if (argc == 3)
  {
    if (strcmp(argv[1], "-b") != 0)
      usage(argv[0]);
    strncpy(filename, argv[2], sizeof(filename) - 1);
    filename[sizeof(filename) - 1] = '\0';
  }
  
  if ((encrypted_file = fopen(filename, "rb")) == NULL)
    return -1;
  fread(encrypted_buffer, 1, 9, encrypted_file);
  if (memcmp(encrypted_buffer, "BLOGBEGIN", 9) != 0)
  {
    fclose(encrypted_file);
    return -1;
  }
  fseek(encrypted_file, 0x89, SEEK_SET); // Skip "BLOGBEGIN" & 1024 bit RSA block
  fread(encrypted_buffer, 1, 16, encrypted_file);
  fclose(encrypted_file);
  memset(&when, 0, sizeof(when));
  sscanf(filename, "debug-%04d%02d%02d-%02d%02d.log", &when.tm_year, &when.tm_mon, &when.tm_mday, &when.tm_hour, &when.tm_min);
  when.tm_year -= 1900;
  when.tm_mon--;
  time_base = mktime(&when);
  for(i = 0; i < 256; i++)
    base_state[i] = (unsigned char)i;
  printf("Bruteforcing RC4 key\n");
  fflush(stdout);
  backup_time_base = time_base - 3600;
  for (j = 0, k = 0; j < 0x04000000; j++)
  {
  	daylight_saving = 1;
  	time_base = backup_time_base;
  	while (daylight_saving) {
	    for (i = time_base; i < (time_base + 60); i++)
	    {
	      if ((k++ & 0xfffff) == 0)
	      {
	        printf(".");
	        fflush(stdout);
	      }
	      // RC4 key [ time ][ GetTickCount ][ GetTickCount * 1000 ][ time ] (lame huh ?)
	      key_data[0] = i;
	      key_data[1] = j;
	      key_data[2] = key_data[1] * 1000;
	      key_data[3] = key_data[0];
	      prepare_key_16((unsigned char *)key_data);
	      memcpy(decrypted_buffer, encrypted_buffer, 16);
	      rc4_16(decrypted_buffer);
	      if (*(unsigned long *)(&decrypted_buffer[8]) == 0x2d495520)
	      {
	        printf("\nRC4 key found: ");
	        for (i = 0; i < 16; i++)
	          printf("%02x", ((unsigned char *)key_data)[i]);
	        printf("\n");
	        fflush(stdout);
	        do_decrypt = 1;
	        goto Decrypt;
	      }
	    }
	    time_base += 3600;
	    daylight_saving--;
	}
  }
  printf("\nRC4 key not found!\n");

Decrypt:

  if (do_decrypt == 1)
  {
    prepare_key((unsigned char *)key_data, 16, &key);
    if ((encrypted_file = fopen(filename, "rb")) == NULL)
      return -1;
    if ((decrypted_file = fopen("log.dump", "wb")) == NULL)
    {
      fclose(encrypted_file);
      return -1;
    }
    fseek(encrypted_file, 0x89, SEEK_SET); // Skip "BLOGBEGIN" & 1024 bit RSA block
    while((l = fread(buffer, 1, SIZE, encrypted_file)) != 0)
    {
      rc4(buffer, l, &key);
      fwrite(buffer, 1, l, decrypted_file);
    }
    fclose(encrypted_file);
    fclose(decrypted_file);
    printf("Log file decrypted\n");
  }

  return 0;
}

/*
C:\Program Files\Skype\Phone>skype_debuglog.exe -b debug-20060208-1627.log
Bruteforcing RC4 key
................................................................................
................................................................................
................................................................................
................................................................................
................................................................................
................................................................................
................................................................................
................................................................................
..........................
RC4 key found: fb0dea433a5fb10090fadbb4fb0dea43
Log file decrypted

C:\Program Files\Skype\Phone>skype_debuglog.exe -k fb0dea433a5fb10090fadbb4fb0dea43 debug-20060208-1627.log
Log file decrypted
*/

/*
1024-bit RSA key
61 27 4B EB 6A 78 79 8D 47 7C 54 4F B9 7E 34 AE D3 21 48 1F BB AD F3 62 32 F1 40 88 79 68 28 0C
0A 32 93 31 BC 13 60 8A 89 E6 0F 01 17 8B 1D 58 3A 37 FA C2 B7 10 14 33 10 EA 42 86 E9 60 2A E0
41 F8 8C 83 E5 F3 EB F5 68 42 A5 8B 1A 1C 73 B1 6A C1 38 71 C2 FA B7 13 1A 08 D8 5F C6 9F 01 98
2E F9 61 DB FF 9F 6E D7 68 AE 78 A8 8E 42 FA 7F B3 2E 0E 12 69 F8 93 6F 3E 43 C4 6A 0E FE 06 C2
*/
